/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MakeTangentCircleCircle.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT MakeTangentCircleCircle(ILine *circle1, ILine *circle2)
{

	//	Creates a Tangent constraint between the two given circles

	START_METHOD("MakeTangentCircleCircle")

	HRESULT status = CONV_SUCCESS;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Get the parent workplane of the object
	IObject *parentWorkplane = NULL;
	status = CAST(IObject, circle1)->GetParent(GetBSTR("Workplane"), &parentWorkplane);
	CHECK_RETURN_STATUS(status)

	ITangent *pTangent = NULL;
	status = (GetCLASS(Tangent))->CreateTangent(circle1, circle2, &pTangent);
	CHECK_RETURN_STATUS(status)

	IConstraint *pConstraint1 = NULL;

	status = CAST(IWorkplane, parentWorkplane)->GetConstraint(CAST(IGeomConstraint, pTangent), &pConstraint1);
	CHECK_RETURN_STATUS(status)

	if(pConstraint1) {
			pTangent->Release();
	}
	else {
			IConstraint *pConstraint = NULL;
			status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint, pTangent), &pConstraint);
			CHECK_RETURN_STATUS(status)
		}
	

	END_METHOD("MakeTangentCircleCircle")
}
